/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.math;

import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public final class MatrixMath {
    private MatrixMath() {
    }

    public static float transformPositionX(Matrix4f matrix, float x, float y, float z) {
        return Math.fma((float)matrix.m00(), (float)x, (float)Math.fma((float)matrix.m10(), (float)y, (float)Math.fma((float)matrix.m20(), (float)z, (float)matrix.m30())));
    }

    public static float transformPositionY(Matrix4f matrix, float x, float y, float z) {
        return Math.fma((float)matrix.m01(), (float)x, (float)Math.fma((float)matrix.m11(), (float)y, (float)Math.fma((float)matrix.m21(), (float)z, (float)matrix.m31())));
    }

    public static float transformPositionZ(Matrix4f matrix, float x, float y, float z) {
        return Math.fma((float)matrix.m02(), (float)x, (float)Math.fma((float)matrix.m12(), (float)y, (float)Math.fma((float)matrix.m22(), (float)z, (float)matrix.m32())));
    }

    public static float transformNormalX(Matrix3f matrix, float x, float y, float z) {
        return Math.fma((float)matrix.m00(), (float)x, (float)Math.fma((float)matrix.m10(), (float)y, (float)(matrix.m20() * z)));
    }

    public static float transformNormalY(Matrix3f matrix, float x, float y, float z) {
        return Math.fma((float)matrix.m01(), (float)x, (float)Math.fma((float)matrix.m11(), (float)y, (float)(matrix.m21() * z)));
    }

    public static float transformNormalZ(Matrix3f matrix, float x, float y, float z) {
        return Math.fma((float)matrix.m02(), (float)x, (float)Math.fma((float)matrix.m12(), (float)y, (float)(matrix.m22() * z)));
    }
}

